/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.blocks;

import com.finallion.graveyard.blockentities.GravestoneBlockEntity;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StandingSignBlock;
import net.minecraft.block.WoodType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SOpenSignMenuPacket;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class GravestoneBlock
extends StandingSignBlock {
    public static final IntegerProperty ROTATION = BlockStateProperties.field_208138_am;
    public static final DirectionProperty FACING = HorizontalFaceBlock.field_185512_D;
    public static final BooleanProperty FLOOR = BlockStateProperties.field_222513_b;
    private static final VoxelShape SHAPE_FACING_EW = Block.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_FACING_NS = Block.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private final ResourceLocation texture;

    public GravestoneBlock(ResourceLocation texture) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200942_a().func_226896_b_().func_200947_a(SoundType.field_235587_I_).func_200943_b(1.5f), WoodType.field_227038_a_);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)FLOOR, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)field_204613_a, (Comparable)Boolean.valueOf(false)));
        this.texture = texture;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, FLOOR, field_204613_a, ROTATION});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        if (Direction.NORTH == state.func_177229_b((Property)FACING) || Direction.SOUTH == state.func_177229_b((Property)FACING)) {
            return SHAPE_FACING_NS;
        }
        return SHAPE_FACING_EW;
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, World p_225533_2_, BlockPos p_225533_3_, PlayerEntity p_225533_4_, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        boolean flag;
        ItemStack itemstack = p_225533_4_.func_184586_b(p_225533_5_);
        boolean bl = flag = itemstack.func_77973_b() instanceof DyeItem && p_225533_4_.field_71075_bZ.field_75099_e;
        if (p_225533_2_.field_72995_K) {
            return flag ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
        }
        TileEntity tileentity = p_225533_2_.func_175625_s(p_225533_3_);
        if (tileentity instanceof GravestoneBlockEntity) {
            boolean flag1;
            GravestoneBlockEntity signtileentity = (GravestoneBlockEntity)tileentity;
            if (flag && (flag1 = signtileentity.setColor(((DyeItem)itemstack.func_77973_b()).func_195962_g())) && !p_225533_4_.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            return signtileentity.executeClickCommands(p_225533_4_) ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }

    public void func_220082_b(BlockState p_220082_1_, World p_220082_2_, BlockPos p_220082_3_, BlockState p_220082_4_, boolean p_220082_5_) {
        super.func_220082_b(p_220082_1_, p_220082_2_, p_220082_3_, p_220082_4_, p_220082_5_);
    }

    public TileEntity func_196283_a_(IBlockReader p_196283_1_) {
        return new GravestoneBlockEntity();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer != null && placer instanceof PlayerEntity) {
            GravestoneBlockEntity sign = (GravestoneBlockEntity)world.func_175625_s(pos);
            if (!world.field_72995_K) {
                sign.setAllowedPlayerEditor(((PlayerEntity)placer).field_71071_by.field_70458_d);
                ((ServerPlayerEntity)placer).field_71135_a.func_147359_a((IPacket)new SOpenSignMenuPacket(pos));
            } else {
                sign.setEditable(true);
            }
        }
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        if (Direction.NORTH == state.func_177229_b((Property)FACING) || Direction.SOUTH == state.func_177229_b((Property)FACING)) {
            return SHAPE_FACING_NS;
        }
        return SHAPE_FACING_EW;
    }

    public BlockState func_196271_a(BlockState p_196271_1_, Direction p_196271_2_, BlockState p_196271_3_, IWorld p_196271_4_, BlockPos p_196271_5_, BlockPos p_196271_6_) {
        if (((Boolean)p_196271_1_.func_177229_b((Property)field_204613_a)).booleanValue()) {
            p_196271_4_.func_205219_F_().func_205360_a(p_196271_5_, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)p_196271_4_));
        }
        return super.func_196271_a(p_196271_1_, p_196271_2_, p_196271_3_, p_196271_4_, p_196271_5_, p_196271_6_);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        Direction direction = context.func_195992_f();
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)direction.func_176734_d())).func_206870_a((Property)field_204613_a, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return Collections.singletonList(new ItemStack((IItemProvider)this));
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public boolean func_196260_a(BlockState p_196260_1_, IWorldReader p_196260_2_, BlockPos p_196260_3_) {
        return p_196260_2_.func_180495_p(p_196260_3_.func_177977_b()).func_185904_a().func_76220_a();
    }
}

